<?php
date_default_timezone_set('Asia/Tokyo');
$PROCESS_DIR = dirname(__FILE__) . '/';

class Logger {
    private $configfile;

    public function __construct() {
        global $PROCESS_DIR;
        $date = date('ym');
        $this->configfile = $PROCESS_DIR . "../log/{$date}.log";
    }

    public function log($msg, $status = "INFO") {
        $now = new DateTime('now', new DateTimeZone('Asia/Tokyo'));
        $date = $now->format('y-m-d H:i:s');
        $text = "[{$date}] : {$status} - {$msg}\n";
        echo $text;

        file_put_contents($this->configfile, $text, FILE_APPEND);
    }
}

class RequestConfig {
    private $access_token = "";
    private $secret_token = "";
    private $domain_name = "";
    private $save_dir;

    public function __construct() {
        global $PROCESS_DIR;
        $this->save_dir = $PROCESS_DIR . "../live/";
    }

    public function setAccessToken($access_token) {
        if (!$access_token) {
            throw new InvalidArgumentException("アクセストークンがありません");
        }
        $this->access_token = $access_token;
    }

    public function getAccessToken() {
        return $this->access_token;
    }

    public function setSecretToken($secret_token) {
        if (!$secret_token) {
            throw new InvalidArgumentException("シークレットトークンがありません");
        }
        $this->secret_token = $secret_token;
    }

    public function getSecretToken() {
        return $this->secret_token;
    }

    public function setSaveDir($save_dir) {
        if ($save_dir) {
            $this->save_dir = $save_dir;
        }
    }

    public function getSaveDir() {
        return $this->save_dir;
    }

    public function setDomainName($domain_name) {
        $this->domain_name = $domain_name;
    }

    public function getDomainName() {
        return $this->domain_name;
    }
}

class Config {
    private $json;
    private $save_dir;
    private $json_datas = [];

    public function __construct() {
        global $PROCESS_DIR;
        $this->save_dir = $PROCESS_DIR . '../live/';
        $config_file = $PROCESS_DIR . '../config.json';
        $json_data = file_get_contents($config_file);
        $this->json = json_decode($json_data, true);
    }

    public function read() {
        $request = $this->json["request"];
        foreach ($request as $req) {
            $request_config = new RequestConfig();
            $request_config->setAccessToken($req["access_token"]);
            $request_config->setSecretToken($req["secret_token"]);
            $request_config->setDomainName($req["domain"]);
            $save_dir = $req["save_dir"];
            $parent_save_dir = $this->save_dir;

            if ($save_dir && '/' == $save_dir[0]) {
                $parent_save_dir = "";
            }
            $request_config->setSaveDir($parent_save_dir . $save_dir);
            $this->json_datas[] = $request_config;
        }
        return $this;
    }

    public function get() {
        return $this->json_datas;
    }
}

class GetKey {
    const FULLCHAIN = 'fullchain';
    const PRIVEKEY = 'privkey';

    private $url;
    private $file_data = "";
    private $save_dir;
    private $keyType;

    public function __construct($keyType = self::FULLCHAIN) {
        $this->keyType = $keyType;
        $this->url = "https://dns.doliot.net/ssl/get/{$keyType}/";
    }

    public function get($request_config) {
        try {
            $access_token = $request_config->getAccessToken();
            $secret_token = $request_config->getSecretToken();
            $res = file_get_contents($this->url . $access_token, false, stream_context_create([
                'http' => [
                    'header' => "X-SECRET-TOKEN: {$secret_token}\r\n"
                ]
            ]));

            if ($res === false) {
                throw new RuntimeException("サーバーエラー");
            }
            $this->file_data = $res;
            $this->save_dir = $request_config->getSaveDir();
            return $this;
        } catch (Exception $e) {
            $LOG = new Logger();
            $LOG->log($e->getMessage(), 'ERROR');
        }
    }

    public function save($dir_name = "") {
        try {
            mkdir("{$this->save_dir}/{$dir_name}/", 0777, true);
        } catch (Exception $e) {
            // Directory already exists
        }
        try {
            $result = file_put_contents("{$this->save_dir}/{$dir_name}/{$this->keyType}.pem", $this->file_data);
            return $result !== false;
        } catch (Exception $e) {
            return false;
        }
    }
}

$request_encript_keys = (new Config())->read()->get();
foreach ($request_encript_keys as $re_key) {
    $getKeyFullchain = (new GetKey(GetKey::FULLCHAIN))->get($re_key)->save($re_key->getDomainName());
    if ($getKeyFullchain) {
        $log_msg = "Get " . GetKey::FULLCHAIN . " key successed for " . $re_key->getDomainName();
        $LOG = new Logger();
        $LOG->log($log_msg);
    } else {
        $log_msg = "Get " . GetKey::FULLCHAIN . " key invaild for " . $re_key->getDomainName();
        $LOG = new Logger();
        $LOG->log($log_msg, 'ERROR');
    }

    $getKeyPrivkey = (new GetKey(GetKey::PRIVEKEY))->get($re_key)->save($re_key->getDomainName());
    if ($getKeyPrivkey) {
        $log_msg = "Get " . GetKey::PRIVEKEY . " key successed for " . $re_key->getDomainName();
        $LOG = new Logger();
        $LOG->log($log_msg);
    } else {
        $log_msg = "Get " . GetKey::PRIVEKEY . " key invaild for " . $re_key->getDomainName();
        $LOG = new Logger();
        $LOG->log($log_msg, 'ERROR');
    }
    sleep(1);
}
?>